/**
* \file: application_state_machine.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: application-framework
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef LIBTESTBEDAPP_SRC_APPLICATION_STATE_MACHINE_H
#define LIBTESTBEDAPP_SRC_APPLICATION_STATE_MACHINE_H

#include "libtestbedapp.h"

extern const char *state_name_table[];

#define asm_state_get_name( state ) state_name_table[(int)( state ) ]

void asm_init(bool service_available, const tba_callbacks_t *callbacks, void *callback_user_data);

void asm_deinit(void);

tba_app_state_t asm_get_state(void);

tba_app_state_t asm_get_previous_state(void);


void asm_enter_ERROR(const char *message, tba_error_code_t error);

unsigned int asm_get_surface_id(void);

void asm_set_state(tba_app_state_t state);

const char *asm_get_error_message(void);

tba_error_code_t asm_get_error_code(void);

void asm_hmi_available_trigger(unsigned int a_surface_id);

void asm_hmi_lost_trigger(void);

void asm_service_available(void);

void asm_service_lost(void);

void asm_send_to_background(void);

void asm_send_to_foreground(void);

bool asm_waking_up_trigger(int arg_RequestId);

bool asm_going_to_shutdown_trigger(int arg_RequestId);

#endif
